TITLE 								       { exa053a.pde }
   'Dipole of Charged Wires'
SELECT
   spectral_colors
DEFINITIONS
   Lx=1     Ly=1     d0=Ly*1e-6     r0=3e-2     qw=1
   eps0=8.85e-12     c=1/(4*pi*eps0)
   U=qw*c*ln(x^2+(y+d0)^2)- qw*c*ln(x^2+(y-d0)^2)
   Ex=-dx(U)     Ey=-dy(U)                  		{ Field components }
   E=-grad(U)     Em=magnitude(E)                      			
   E_angle=sign(Ey)*arccos(Ex/Em)/pi*180 	{ Degrees }
BOUNDARIES
region 'domain'
   start(-Lx,-Ly)  line to (Lx,-Ly) to (Lx,Ly)  to (-Lx,Ly) close
   start(r0,0) arc( center=0,0) angle=360     { Replaces two circles }
PLOTS
   contour( U)   contour( Ex)   contour( Ey)	
   contour( abs(Ex)) log	   contour( abs(Ey)) log
   contour( Em) log   vector( E/Em)	  contour( E_angle)
   contour( del2(U))					{ Plot of Laplacian }
   contour( dx(Ey)- dy(Ex))			  	{ Plot of curl_z }
END

